﻿//////////////////////////////////////////////
// CompilerSettings.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

// Check if we use msvc for compilation
#if defined(_MSC_VER)

	// Allowing de-virtualization through the final keyword
	// This allows client applications to shortcut virtual calls by resolving them at compile time
	// However, this can lead to issues if compiler settings are not properly aligned, as it can side track methods exported by the engine
	#if defined(NK_ALLOW_DEVIRTUALIZATION)
		#define NK_FINAL final
	#else
		#define NK_FINAL
	#endif

#else

	// Ignore for wasm
	#define NK_FINAL final

#endif